<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cuidado de Sí</title>
    <meta name="description" content="Sitio oficial de Cuidado de Sí: servicios, biografía, eventos, blog y más sobre el cuidado de sí.">
    <meta name="author" content="Fr. Ramiro Álvarez">
    <meta name="robots" content="index, follow">
    <link rel=" shortcut icon" href="public/favicon.ico" type="image/x-icon">
    <!--Bootstrap-->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet">
    <!--FontAwesome-->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" />
    <!--CSS-->
    <link rel="stylesheet" href="style.css">

    <?php
    $page = $_GET['page'] ?? 'home';
    $pathPageCSS = "./resources/views/pages/{$page}/{$page}.css";
    if (file_exists($pathPageCSS)) {
        echo "<link rel='stylesheet' href='./resources/views/pages/{$page}/{$page}.css'/>";
    }
    ?>
</head>

<body>
    <header class="py-4 d-flex justify-content-center align-items-center">
        <nav class="container d-flex flex-column navbar navbar-expand-md navbar-light bg-white border-0 p-0" style="width: 100%; height: 100%;">
            <aside id="customOffcanvas" class="custom-offcanvas">
                <div class="custom-offcanvas-header">
                    <button id="customCloseBtn" class="custom-btn-close" aria-label="Cerrar menú">&times;</button>
                </div>
                <nav class="custom-offcanvas-body">
                    <ul class="navbar-nav">
                        <li class="nav-item"><a href="?page=home" class="nav-link">INICIO</a></li>
                        <li class="nav-item"><a href="?page=home#biografia" class="nav-link">BIOGRAFÍA</a></li>
                        <li class="nav-item"><a href="?page=services" class="nav-link">SERVICIOS</a></li>
                        <li class="nav-item"><a href="?page=home#galeria" class="nav-link">GALERÍA</a></li>
                        <li class="nav-item"><a href="?page=home#eventos" class="nav-link">EVENTOS</a></li>
                        <li class="nav-item"><a href="?page=home#videos" class="nav-link">VIDEOS</a></li>
                        <li class="nav-item"><a href="?page=blog" class="nav-link">BLOG</a></li>
                        <li class="nav-item"><a href="?page=home#contacto" class="nav-link">CONTACTO</a></li>
                    </ul>
                    <div class="custom-offcanvas-footer">
                        <div class="text-start mb-4">
                            <h2 class="h5">FR. RAMIRO ÁLVAREZ</h2>
                            <p class="mb-2">(214) 555-0198</p>
                        </div>
                        <ul class="d-flex flex-wrap justify-content-start gap-3 list-unstyled">
                            <li><a href="#"><i class="i-icon fa-brands fa-facebook"></i></a></li>
                            <li><a href="#"><i class="i-icon fa-brands fa-instagram"></i></a></li>
                            <li><a href="https://www.youtube.com/@RamiroAlvarez-cuidadodesi"><i class="i-icon fa-brands fa-youtube"></i></a></li>
                            <li><a href="#"><i class="i-icon fa-brands fa-tiktok"></i></a></li>
                            <li><a href="#"><i class="i-icon fa-brands fa-spotify"></i></a></li>
                        </ul>
                    </div>
                </nav>
            </aside>
            <div id="customOffcanvasBackdrop" class="custom-offcanvas-backdrop"></div>
            <div class="row align-items-center text-center text-md-start w-100">
                <div class="col-12 p-0 mb-4 d-flex justify-content-end">
                    <button id="customMenuBtn" class="custom-navbar-toggler d-md-none" aria-label="Abrir menú">
                        <span class="custom-navbar-toggler-icon"></span>
                    </button>
                </div>
                <div class="col-12 col-md-3 mb-3 mb-md-0 d-flex justify-content-center justify-content-md-start align-items-center">
                    <img src="public/favicon.ico" alt="Logo" style="max-width: 120px;" loading="eager">
                </div>
                <div class="col-12 col-md-6 mb-3 mb-md-0 d-flex justify-content-center align-items-center">
                    <h1 class="m-0" style="font-family: 'TituloFont', Arial, serif; font-size: 2.5rem;">FR. RAMIRO ÁLVAREZ</h1>
                </div>
                <div class="col-12 col-md-3 d-flex justify-content-center justify-content-md-end align-items-center gap-2">
                    <a href="#"><i class="i-icon fa-brands fa-facebook fa-lg"></i></a>
                    <a href="#"><i class="i-icon fa-brands fa-instagram fa-lg"></i></a>
                    <a href="#"><i class="i-icon fa-brands fa-youtube fa-lg"></i></a>
                    <a href="#"><i class="i-icon fa-brands fa-tiktok fa-lg"></i></a>
                    <a href="#"><i class="i-icon fa-brands fa-spotify fa-lg"></i></a>
                </div>
            </div>
            <div class="row collapse navbar-collapse d-none d-md-block w-100 mt-3" id="mainNavbar">
                <ul class="nav justify-content-between flex-wrap border-bottom pb-2">
                    <li class="nav-item"><a href="?page=home" class="nav-link px-3">INICIO</a></li>
                    <li class="nav-item"><a href="?page=home#biografia" class="nav-link px-3">BIOGRAFÍA</a></li>
                    <li class="nav-item"><a href="?page=services" class="nav-link px-3">SERVICIOS</a></li>
                    <li class="nav-item"><a href="?page=home#galeria" class="nav-link px-3">GALERÍA</a></li>
                    <li class="nav-item"><a href="?page=home#eventos" class="nav-link px-3">EVENTOS</a></li>
                    <li class="nav-item"><a href="?page=home#videos" class="nav-link px-3">VIDEOS</a></li>
                    <li class="nav-item"><a href="?page=blog" class="nav-link px-3">BLOG</a></li>
                    <!--<li class="nav-item"><a href="?page=donaciones" class="nav-link px-3">DONACIONES</a></li>-->
                    <li class="nav-item"><a href="?page=home#contacto" class="nav-link px-3">CONTACTO</a></li>
                </ul>
            </div>
        </nav>
    </header>
    <main>
        <?php
        $path = "./resources/views/pages/{$page}/{$page}.php";
        if (file_exists($path)) {
            require_once $path;
        } else {
            require_once './resources/views/pages/404/404.php';
        }
        ?>
        <!--<section class="sections d-flex justify-content-center align-items-center py-5 mb-5" style="background-color: #f1ebe4;">
            <div class="container py-5">
                <div class="row justify-content-center">
                    <div class="col-12 col-md-8 text-center">
                        <span class="d-block mb-2" style="color: #19b0df; font-family: 'TituloFont', Arial, sans-serif; letter-spacing: 1px;">DONACIONES</span>
                        <h2 class="mb-3" style="font-family: 'TituloFont', Arial, sans-serif; font-size: 2.8rem;">¡Apoya esta misión!</h2>
                        <p class="mb-4 fs-6">Un pequeño gesto, un gran cambio.</p>
                        <a href="?page=donaciones" class="btn btn-info text-white px-5 py-2 fs-5 rounded-4 fw-bold" style="background-color: #19b0df; border: none;">Donar</a>
                    </div>
                </div>
            </div>
        </section>-->
        <section class="section-home-three d-flex justify-content-end align-items-center mb-3">
            <div class="container">
                <div class="row justify-content-end" style="min-height: 400px;">
                    <div class="col-12 col-md-6 d-flex flex-column justify-content-center align-items-center align-items-md-center three">
                        <div>
                            <h3 class="text-center text-md-end fade-in-right">Recibe nuestras últimas noticias</h3>
                        </div>
                        <div class="mt-3 w-100">
                            <form action="" method="POST" class="bg-white p-3 rounded-4" id="form">
                                <div class="d-flex flex-column">
                                    <div class="mb-3">
                                        <input class="form-control border-0 mb-2" type="text" name="name" placeholder="Nombre completo" required>
                                    </div>
                                    <div class="mb-3">
                                        <input class="form-control border-0 mb-2" type="tel" name="phone" placeholder="Teléfono (opcional)">
                                    </div>
                                    <div class="d-flex flex-column flex-md-row justify-content-center align-items-center">
                                        <input class="form-control border-0 mb-2 mb-md-0 me-md-2" type="email" name="email" placeholder="Correo electrónico" required>
                                        <button class="btn btn-info text-white fw-bold px-5 py-2 ms-md-4 rounded-4" type="button" id="enviar">Enviar</button>
                                    </div>
                                </div>
                                <div id="alerta-suscripcion"></div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <footer class="text-white d-flex justify-content-center align-items-center" id="contacto">
        <div class="container">
            <div class="row align-items-center text-center text-md-start m-0 p-0">
                <div class="col-12 col-md-3 mb-4 mb-md-0">
                    <img src="public/assets/images/LOGO.png" alt="Logo" class="img-fluid mb-2" loading="lazy">
                </div>
                <div class="col-12 col-md-3 mb-4 mb-md-0">
                    <ul class="list-unstyled">
                        <li><a href="?page=home" class="text-decoration-none text-white">INICIO</a></li>
                        <li class="mt-3"><a href="?page=home#biografia" class="text-decoration-none text-white">BIOGRAFÍA</a></li>
                        <li class="mt-3"><a href="?page=services" class="text-decoration-none text-white">SERVICIOS</a></li>
                        <li class="mt-3"><a href="?page=home#galeria" class="text-decoration-none text-white">GALERÍA</a></li>
                    </ul>
                </div>
                <div class="col-12 col-md-3 mb-4 mb-md-0">
                    <ul class="list-unstyled">
                        <li class="mb-3"><a href="?page=home#eventos" class="text-decoration-none text-white">EVENTOS</a></li>
                        <li><a href="?page=home#videos" class="text-decoration-none text-white">VIDEOS</a></li>
                        <li class="mt-3"><a href="?page=blog" class="text-decoration-none text-white">BLOG</a></li>
                        <!--<li class="mt-3"><a href="?page=donaciones" class="text-decoration-none text-white">Donaciones</a></li>-->
                        <!--<li class="mt-3"><a href="?page=home#contacto" class="text-decoration-none text-white">Contacto</a></li>-->
                    </ul>
                </div>
                <div class="col-12 col-md-3 d-flex flex-column align-items-center align-items-md-start">
                    <div>
                        <h2 class="h5">FR. RAMIRO ÁLVAREZ</h2>
                        <p class="mb-2">(214) 555-0198</p>
                    </div>
                    <ul class="d-flex justify-content-center justify-content-md-start gap-3 list-unstyled mt-2">
                        <li><a href="#"><i class="i-icon fa-brands fa-facebook fa-lg"></i></a></li>
                        <li><a href="#"><i class="i-icon fa-brands fa-instagram fa-lg"></i></a></li>
                        <li><a href="https://www.youtube.com/@RamiroAlvarez-cuidadodesi"><i class="i-icon fa-brands fa-youtube fa-lg"></i></a></li>
                        <li><a href="#"><i class="i-icon fa-brands fa-tiktok fa-lg"></i></a></li>
                        <li><a href="#"><i class="i-icon fa-brands fa-spotify fa-lg"></i></a></li>
                    </ul>
                </div>
            </div>
        </div>
    </footer>
    <a href="https://wa.me/1234567890?text=hello+123" target=”_blank” class="whatsapp-btn">
        <i class="fa-brands fa-whatsapp" style="color: #ffffff;"></i>
    </a>
    <!-- JQuery -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <!--Bootstrap-->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js"></script>
    <!--DataTables-->
    <script src="https://cdn.datatables.net/2.3.2/js/dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/2.3.2/js/dataTables.jqueryui.min.js"></script>
    <script src="https://cdn.datatables.net/2.3.2/js/dataTables.bootstrap5.min.js"></script>
    <!--SweetAlert-->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!--Pagination-->
    <script src="https://cdn.jsdelivr.net/npm/paginationjs@2.6.0/dist/pagination.min.js"></script>
    <!--JS-->
    <?php
    if ($page == 'home') {
        if (file_exists(__DIR__ . '/app.js')) {
            echo '<script src="app.js"></script>';
        }
    } else {
        $pathjs = "./resources/views/pages/{$page}/{$page}.js";
        if (file_exists($pathjs)) {
            echo "<script src='./resources/views/pages/{$page}/{$page}.js'></script>";
        }
    }
    ?>
</body>

</html>