// Función para detectar y redirigir según el idioma
function detectAndRedirectLanguage() {
    const userLang = navigator.language || navigator.userLanguage;
    const currentPath = window.location.pathname;
    
    // Obtener el idioma base (primeros 2 caracteres)
    const baseUserLang = userLang.substring(0, 2).toLowerCase();
    
    // Determinar si estamos en la sección en inglés o español
    const isInEnglishSection = currentPath.includes('/en/');
    const isInSpanishSection = currentPath.includes('/es/');
    
    // Redirigir según el idioma detectado
    if (baseUserLang === 'es' && !isInSpanishSection) {
        const newPath = currentPath.replace('/en/', '/es/');
        window.location.href = newPath;
    } else if (baseUserLang !== 'es' && !isInEnglishSection) {
        const newPath = currentPath.replace('/es/', '/en/');
        window.location.href = newPath;
    }
}

// Ejecutar la detección de idioma cuando se carga la página
// document.addEventListener('DOMContentLoaded', detectAndRedirectLanguage);


$(()=> {
    let currentLanguage = 'es'; // Idioma por defecto
    
    // Detectar el idioma actual basado en la URL
    const currentPath = window.location.pathname;
    const isEnglish = currentPath.includes('/en/');
    
    // Actualizar el idioma por defecto según la URL
    if (isEnglish) {
        currentLanguage = 'en';
    }
    
    // Función para cargar los blogs según el idioma
    const loadBlogs = (language) => {
        const spinner = `<div id="spinner-blogs" class="d-flex justify-content-center align-items-center my-5">
            <div class="spinner-border text-info" role="status" style="width: 3rem; height: 3rem;">
                <span class="visually-hidden">Cargando...</span>
            </div>
        </div>`;
        $('#blogs').html(spinner);
        
        // Configurar el sistema según el idioma
        const sistema = language === 'en' ? 'sistema_en' : 'sistema_es';
        const endpoint = language === 'en' ? '/blogs_en/list/active' : '/blogs/list/active';
        
        // URL para la petición AJAX
        const ajaxUrl = `${window.location.origin}/cuidado/sistema/${sistema}/routes/web.php`;
        
        $.ajax({
            url: ajaxUrl,
            type: 'POST',
            data: {REQUEST_URI: endpoint},
            success: (response) => {
                const blogs = response.blogs;
                const divBlogs = document.getElementById('blogs');
                $('#spinner-blogs').remove();

                if (!blogs || blogs.length === 0) {
                    divBlogs.innerHTML = `
                        <div class="col-12 text-center py-5">
                            <i class="fa-regular fa-newspaper fa-2x mb-2 text-info"></i>
                            <div class="text-muted">${language === 'en' ? 'Articles coming soon' : 'Próximamente artículos disponibles'}</div>
                        </div>
                    `;
                    return;
                }

                // Actualizar la paginación
                $('#pagination-container').pagination({
                    dataSource: blogs,
                    pageSize: 12,
                    callback: function(data, pagination) {
                        divBlogs.innerHTML = '';
                        data.forEach((b) => {
                            const readMoreText = language === 'en' ? 'Read more' : 'Ver más';
                            divBlogs.innerHTML += `
                                <div class="col-12 col-md-3">
                                    <div>
                                        <img src="/cuidado/sistema/${sistema}/resources/images/blogs/${b.img}" 
                                             class="rounded-4 w-100 mb-2" 
                                             style="aspect-ratio: 16/9; object-fit: cover;" 
                                             alt="${b.title}">
                                        <div class="d-flex flex-column justify-content-between">
                                            <span class="fw-bold subtitle-size title blog-title-ellipsis my-2" 
                                                  style="font-size: 1.3rem;">${b.title}</span>
                                            <a href="?page=detailBlog&id=${b.id}" 
                                               class="btn btn-outline-primary rounded-pill px-4 mb-2">
                                               ${readMoreText}
                                            </a>
                                        </div>
                                    </div>
                                </div>`;
                        });
                    }
                });
            },
            error: function(xhr, status, error) {
                console.error('Error en la petición AJAX:', {
                    status: xhr.status,
                    statusText: xhr.statusText,
                    responseText: xhr.responseText,
                    error: error
                });
                $('#blogs').html(`
                    <div class="col-12 text-center py-5">
                        <i class="fa-solid fa-triangle-exclamation fa-2x mb-2 text-warning"></i>
                        <div class="text-muted">${currentLanguage === 'en' ? 'Error loading blogs' : 'Error al cargar los blogs'}</div>
                    </div>
                `);
            }
        });
    };

    // Configurar los botones de idioma
    const setupLanguageButtons = () => {
        const buttons = document.querySelectorAll('.language-btn');
        
        // Marcar el botón activo inicial
        document.querySelector(`[data-language="${currentLanguage}"]`).classList.add('active');
        
        buttons.forEach(btn => {
            btn.addEventListener('click', function() {
                // Remover clase activa de todos los botones
                buttons.forEach(b => b.classList.remove('active'));
                
                // Agregar clase activa al botón clickeado
                this.classList.add('active');
                
                // Actualizar idioma actual y recargar blogs
                currentLanguage = this.dataset.language;
                loadBlogs(currentLanguage);
                
                // Actualizar textos de la página según el idioma
                const pageTitle = document.querySelector('[data-translate="blog.page_title"]');
                const sectionTitle = document.querySelector('[data-translate="blog.section_title"]');
                
                if (currentLanguage === 'en') {
                    pageTitle.textContent = 'Guide for your wellness';
                    sectionTitle.textContent = 'Blog';
                } else {
                    pageTitle.textContent = 'Guía para tu bienestar';
                    sectionTitle.textContent = 'Blog';
                }
            });
        });
    };
    
    // Inicializar los botones de idioma y cargar blogs
    setupLanguageButtons();
    loadBlogs(currentLanguage);
    
    /* Código duplicado comentado - la lógica ya está en loadBlogs()
    const spinner = `<div id="spinner-blogs" class="d-flex justify-content-center align-items-center my-5">
        <div class="spinner-border text-info" role="status" style="width: 3rem; height: 3rem;">
            <span class="visually-hidden">Cargando...</span>
        </div>
    </div>`;
    $('#blogs').html(spinner);
    
    // Configurar la URL y los parámetros según el idioma
    const sistema = isEnglish ? 'sistema_en' : 'sistema_es';
    const endpoint = isEnglish ? '/blogs_en/list/active' : '/blogs/list/active';
    
    // Construir la URL para la petición AJAX
    const ajaxUrl = `${window.location.origin}/cuidado/sistema/${sistema}/routes/web.php`;
    
    // Debugging mejorado
    console.log('Debug Info:', {
        originalUrl: window.location.href,
        currentPath,
        sistema,
        ajaxUrl,
        endpoint,
        isEnglish
    });*/
    
    /* Resto del código duplicado comentado
    $.ajax({
        url: ajaxUrl,
        type: 'POST',
        data: {REQUEST_URI: endpoint},
        error: function(xhr, status, error) {
            console.error('Error en la petición AJAX:', {
                status: xhr.status,
                statusText: xhr.statusText,
                responseText: xhr.responseText,
                error: error
            });
        },
        success: (response)=>{
            const blogs = response.blogs;
            const divBlogs = document.getElementById('blogs');
            $('#spinner-blogs').remove();

            if (!blogs || blogs.length === 0) {
                if (divBlogs) {
                    divBlogs.innerHTML = `
                        <div class="col-12 text-center py-5">
                            <i class="fa-regular fa-newspaper fa-2x mb-2 text-info"></i>
                            <div class="text-muted">Próximamente artículos disponibles</div>
                        </div>
                    `;
                }
                return;
            }

            $('#pagination-container').pagination({
                dataSource: blogs,
                pageSize: 12,
                callback: function(data, pagination){
                    divBlogs.innerHTML = '';
                    data.forEach((b) => {
                        divBlogs.innerHTML += `
                            <div class="col-12 col-md-3">
                                <div>
                                    <img src="/cuidado/sistema/${sistema}/resources/images/blogs/${b.img}" class="rounded-4 w-100 mb-2" style="aspect-ratio: 16/9; object-fit: cover;" alt="${b.title}">
                                    <div class="d-flex flex-column justify-content-between">
                                        <span class="fw-bold subtitle-size title blog-title-ellipsis my-2" style="font-size: 1.3rem;">${b.title}</span>
                                        <a href="/${isEnglish ? 'cuidado/en/' : 'cuidado/es/'}?page=detailBlog&id=${b.id}" class="btn btn-light rounded-pill px-4 mb-2">${isEnglish ? 'Read more' : 'Ver más'}</a>
                                    </div>
                                </div>
                            </div>`;
                    });
                }
            });
        },
    })
    */
})

document.addEventListener('DOMContentLoaded', function() {

    const translator = new Translator();
    translator.init();
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible');
            } else {
                entry.target.classList.remove('visible');
            }
        });
    }, {
        threshold: 0.2 
    });

    document.querySelectorAll('.fade-in-up, .fade-in-left, .fade-in-right').forEach(el => {
        observer.observe(el);
    });


    document.querySelectorAll('a[href^="#"], a[href^="?page=home#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            let href = this.getAttribute('href');
            let hash = '';
            const isEnglish = window.location.pathname.includes('/en/');
            
            if (href.startsWith('?page=home#')) {
                hash = href.split('#')[1];
                if (window.location.search.indexOf('page=home') === -1) {
                    localStorage.setItem('scrollToHash', hash);
                    window.location.href = `/${isEnglish ? 'cuidado/en/' : 'cuidado/es/'}?page=home#${hash}`;
                    return;
                }
            } else if (href.startsWith('#')) {
                hash = href.substring(1);
            }
            if (hash) {
                const target = document.getElementById(hash);
                if (target) {
                    e.preventDefault();
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                    const offcanvas = document.querySelector('.offcanvas.show');
                    if (offcanvas) {
                        const bsOffcanvas = bootstrap.Offcanvas.getInstance(offcanvas);
                        if (bsOffcanvas) bsOffcanvas.hide();
                    }
                }
            }
        });
    });

    const hashToScroll = localStorage.getItem('scrollToHash');
    if (hashToScroll) {
        const target = document.getElementById(hashToScroll);
        if (target) {
            setTimeout(() => {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }, 300);
        }
        localStorage.removeItem('scrollToHash');
    }
});

document.addEventListener('hidden.bs.offcanvas', function (event) {

    if (window.location.pathname === '/' || window.location.pathname.endsWith('index.php')) {
        if (window.location.hash) {
            history.replaceState(null, null, window.location.pathname + window.location.search);
        }
    }
});


document.getElementById('customMenuBtn').addEventListener('click', function() {
    document.getElementById('customOffcanvas').classList.add('open');
    document.getElementById('customOffcanvasBackdrop').classList.add('open');
    document.body.style.overflow = 'hidden';
});
document.getElementById('customCloseBtn').addEventListener('click', closeCustomOffcanvas);
document.getElementById('customOffcanvasBackdrop').addEventListener('click', closeCustomOffcanvas);
function closeCustomOffcanvas() {
    document.getElementById('customOffcanvas').classList.remove('open');
    document.getElementById('customOffcanvasBackdrop').classList.remove('open');
    document.body.style.overflow = '';
}
document.querySelectorAll('#customOffcanvas .nav-link').forEach(link => {
    link.addEventListener('click', closeCustomOffcanvas);
});

$('#enviar').on('click', function(e) {
        e.preventDefault();
        const emailInput = $('#form [name="email"]');
        const email = emailInput.val().trim();
        const alerta = $('#alerta-suscripcion');


        const emailRegex = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
        const accentRegex = /[áéíóúÁÉÍÓÚñÑüÜ]/;


        if (!email) {
            alerta.html(`
                <div class="alert alert-warning alert-dismissible fade show mt-3" role="alert"
                    style="border-left: 5px solid #ffc107; box-shadow: 0 4px 12px rgba(255, 193, 7, 0.2); font-size: 1rem;">
                    <strong>⚠️ Atención:</strong> Por favor ingresa tu correo electrónico.
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
                </div>
            `);
            return;
        }

        if (!emailRegex.test(email)) {
            alerta.html(`
                <div class="alert alert-warning alert-dismissible fade show mt-3" role="alert"
                    style="border-left: 5px solid #ffc107; box-shadow: 0 4px 12px rgba(255, 193, 7, 0.2); font-size: 1rem;">
                    <strong>📧 Correo no válido:</strong> Asegúrate de ingresar un correo electrónico correcto.
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
                </div>
            `);
            return;
        }

        if (accentRegex.test(email)) {
            alerta.html(`
                <div class="alert alert-warning alert-dismissible fade show mt-3" role="alert"
                     style="border-left: 5px solid #ffc107; box-shadow: 0 4px 12px rgba(255, 193, 7, 0.2); font-size: 1rem;">
                    <strong>❌ Sin acentos:</strong> El correo no debe contener acentos ni caracteres especiales como "ñ".
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
                </div>
            `);
            return;
        }

        $.post('../sistema_es/routes/web.php', {
                REQUEST_URI: '/mail/send',
                email
            })
            .done(function(response) {
                emailInput.val('');
                alerta.html(`
                    <div class="alert alert-success alert-dismissible fade show mt-3" role="alert"
                         style="border-left: 5px solid #198754; box-shadow: 0 4px 12px rgba(25, 135, 84, 0.2); font-size: 1rem;">
                        <strong>✅ ¡Gracias!</strong> Te has suscrito correctamente.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
                    </div>
                `);
            })
            .fail(function() {
                alerta.html(`
                    <div class="alert alert-danger alert-dismissible fade show mt-3" role="alert"
                         style="border-left: 5px solid #dc3545; box-shadow: 0 4px 12px rgba(220, 53, 69, 0.2); font-size: 1rem;">
                        <strong>⚠️ Error:</strong> No se pudo completar la suscripción. Intenta más tarde.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
                    </div>
                `);
            });
    });