<!-- HERO -->
<div class="container-fluid section-specific-course">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-6 text-center">
                <h1
                    class="text-white fade-in-left"
                    style="font-size: 4rem;">
                    Geometry of the Soul
                </h1>
            </div>
        </div>
    </div>
</div>

<!-- INTRO -->
<div class="container py-5 my-5">
    <div class="row align-items-center">
        <div class="col-12 col-lg-6 mb-4 mb-lg-0 d-flex justify-content-center">
            <img
                src="/cuidado/public/assets/images/GEOMETRIA.png"
                alt="geometria"
                class="img-fluid rounded-4"
                style="max-width: 500%;"
                loading="eager" />
        </div>
        <div class="col-12 col-lg-6 course-responsive">
            <p
                class="fw-bold mb-4 fs-5"
                style="text-align: justify;">
                Each person possesses an inner geometry: patterns that reveal how
                we think, feel and act.
            </p>
            <p
                class="mb-4 fs-5"
                style="text-align: justify;">
                Understanding this geometry means deciphering the map of your soul to
                transform it into freedom, mental health and spiritual fulfillment.
            </p>
        </div>
    </div>
</div>

<!-- OBJETIVO -->
<div class="my-5 py-5" style="background-color: #f4ece4;">
    <div class="container py-4 my-4">
        <div class="row align-items-center">
            <div class="col-12 col-lg-6 order-2 order-lg-1 course-responsive">
                <h2
                    class="fade-in-left subtitle"
                    style="font-size: 3rem;">
                    🎯 Program Objective
                </h2>
                <p
                    class="fw-bold mb-4 fs-5"
                    style="text-align: justify;">
                    Geometry of the Soul seeks for each person to recognize the patterns
                    that structure their life, integrate psychological and
                    spiritual resources, and develop a more conscious way of inhabiting
                    themselves, their relationships and their environment.
                </p>
            </div>
            <div
                class="col-12 col-lg-6 order-1 order-lg-2 d-flex justify-content-center mb-4 mb-lg-0">
                <img
                    src="/cuidado/public/assets/images/GEO_1.png"
                    alt="objetivo"
                    class="img-fluid rounded-4"
                    style="max-width: 90%;"
                    loading="lazy" />
            </div>
        </div>
    </div>
</div>

<!-- DIFERENCIAS -->
<div class="container my-5 py-5">
    <div class="row align-items-center">
        <div class="col-12 col-lg-6 mb-4 mb-lg-0 d-flex justify-content-center">
            <img
                src="/cuidado/public/assets/images/GEO_2.png"
                alt="metodologia"
                class="img-fluid rounded-4"
                style="max-width: 90%;"
                loading="lazy" />
        </div>
        <div class="col-12 col-lg-6 course-responsive">
            <h2
                class="fw-bold mb-4 fs-3">
                Why is Geometry of the Soul different?
            </h2>
            <p
                class="fw-bold mb-4 fs-5">
                Most self-knowledge programs are limited to describing personality types. 
                Geometry of the Soul goes beyond because:
            </p>
            <ul>
                <li
                    class="mb-3 fs-5">
                    🌀 Integrates psychoanalysis to understand not only how you are, but
                    why you act that way, revealing the unconscious roots of your history.
                </li>
                <li
                    class="mb-3 fs-5">
                    ✡ Provides the wisdom of the Judeo-Christian tradition, which illuminates the
                    inner geometry with symbols and spiritual keys of
                    transcendence.
                </li>
                <li
                    class="mb-3 fs-5">
                    💡 Applies Rational Emotive Therapy, offering practical
                    tools to transform limiting thoughts and achieve greater
                    emotional and existential freedom.
                </li>
                <li
                    class="mb-3 fs-5">
                    🎓 Led by a facilitator with solid psychological and
                    spiritual training: Ramiro A. Álvarez, Mg. — psychologist and psychoanalyst, with
                    more than 30 years of experience in human and community accompaniment.
                </li>
            </ul>
        </div>
    </div>
</div>

<!-- DESCUBRE -->
<div class="my-5 py-5" style="background-color: #f4ece4;">
    <div class="container py-4 my-4">
        <div class="row align-items-center">
            <div class="col-12 col-lg-12 course-responsive">
                <h2
                    class="fw-bold mb-4 mt-4 fade-in-up fs-3">
                    ✨ Discover the geometry of your soul: from ego to love
                </h2>
                <p
                    class="fw-bold mt-4 fs-5">
                    This combination makes Geometry of the Soul a unique,
                    deep and contemporary program, where the psychological and spiritual unite
                    for a true individual and collective transformation.
                </p>

                <h3
                    class="fw-bold mt-4 mb-3 fs-4">
                    🚀 Benefits of analyzing the geometry of your soul
                </h3>
                <ul>
                    <li class="fs-5">
                        🔍 Self-knowledge – Know your internal map to live with
                        authenticity.
                    </li>
                    <li class="fs-5">
                        🧭 Self-leadership – Learn to direct your life with clarity and
                        purpose.
                    </li>
                    <li class="fs-5">
                        🤝 Conflict resolution – Tools to overcome differences
                        with maturity.
                    </li>
                    <li class="fs-5">
                        🏡 Family relationships – Transform bonds into spaces of
                        growth.
                    </li>
                    <li class="fs-5">
                        👥 Work teams – Create solid and collaborative
                        communities.
                    </li>
                    <li class="fs-5">
                        🌱 Spiritual growth – Move from ego to love, from wound to
                        fullness.
                    </li>
                </ul>

                <p
                    class="fw-bold mt-4 fs-5">
                    Directed to people of all ages seeking self-knowledge,
                    inner healing and spiritual growth.
                </p>
            </div>
        </div>
    </div>
</div>

<!-- METODOLOGÍA -->
<div class="container my-2 py-3">
    <div class="row align-items-center">
        <div class="col-12 col-lg-12 course-responsive">
            <h1
                class="fw-bold mb-4 mt-4 fade-in-up fs-2">
                🎯 Methodology
            </h1>
            <ul>
                <li class="fs-5">
                    Group sessions: shared and dynamic learning.
                </li>
                <li class="fs-5">
                    Family sessions: understanding and transformation of bonds in the
                    home.
                </li>
                <li class="fs-5">
                    Private sessions: personalized accompaniment in your own
                    process.
                </li>
                <li class="fs-5">
                    Unique integration of psychoanalysis, spiritual wisdom and Rational
                    Emotive Therapy.
                </li>
            </ul>
            <p
                class="fw-bold mt-4 fs-6">
                Academic and spiritual direction by Ramiro Álvarez, Mg., with interdisciplinary
                training and international experience.
            </p>
            <p
                class="fw-bold mt-4 mb-4 fs-6">
                🚪 Dare to enter the geometry of your soul. A deep and
                practical journey that transforms ego into love, conflict into growth and
                search into fullness.
            </p>
        </div>
    </div>
</div>

<style>
.section-specific-course{
    place-content: center;
    min-height: 55vh;
    background-image: url('<?php echo $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST']; ?>/cuidado/public/assets/images/BANNER_GEO.png');
    background-position: center;
    background-repeat: no-repeat;
    background-size: cover;
}
</style>