<section class="section-home-one d-flex align-items-center">
    <div class="container">
        <div class="row justify-content-start">
            <div class="col-12 col-md-6 col-lg-5">
                <div class="container-home-one py-5">
                    <h2 class="fs-1 fade-in-left">El cuidado de sí es la puerta al cuidado del mundo.</h2>
                    <p class="fade-in-up mt-4">
                        Cuidado de Sí es una propuesta innovadora y
                        sumamente atractiva que surge de la
                        necesidad de unificar la salud mental y la
                        espiritual en el ser humano.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="container inicio section-home-margin">
    <h2 class="h2-title h2-title-margin fade-in-left">INICIO</h2>
    <div class="row g-4">
        <div class="col-12 col-md-6">
            <article class="article-cds me-md-5">
                <span class="fade-in-left title">
                    <span class="circle-responsive" style="color: #19b0df; font-size: 3rem;">●</span>
                    <span class="fs-1 subtitle">Cuidado de Sí</span>
                </span>
                <p class="fw-bold fade-in-up">
                    El cuidado es un principio esencial que abarca nuestra relación con
                    nosotros mismos, con los demás y con el medio ambiente. Implica un
                    compromiso activo con la protección y el bienestar de todos los seres
                    vivos. Cuidarnos nos permiteestar en mejor posición para cuidar de los
                    demás y del mundo que nos rodea. Esto incluye prácticas como la
                    meditación, el ejercicio y la alimentación saludable, que nos fortalecen
                    tanto física como emocionalmente.
                </p>
                <p class="fade-in-up">
                    Cuidado de Sí es una propuesta innovadora y sumamente atractiva que
                    surge de la necesidad de unificar la salud mental y la espiritualidad en el ser
                    humano. Es promovida acertadamente por Ramiro Álvarez, sacerdote y
                    psicoterapeuta.
                </p>
                <p class="fade-in-up m-0">
                    Este enfoque implica una serie de actividades que el individuo emprende
                    con el fin de volver la mirada sobre sí mismo: sus pensamientos, emociones,
                    acciones y relaciones con los demás. Estas prácticas, denominadas
                    "tecnologías del yo", provienen de la reflexión del filósofo francés Michel
                    Foucault, quien exploró el concepto del cuidado de sí como una forma de
                    autoconocimiento y transformación personal.
                </p>
            </article>
        </div>
        <div class="col-12 col-md-6 m-0">
            <article class="article-mision-vision rounded">
                <h3 class="mb-3 fade-in-left subtitle-size">Misión</h3>
                <p class="mb-5 fade-in-up">
                    <span class="fw-bold">Brindar recursos y orientación para que las personas
                        emprendan un viaje de transformación personal a través del
                        cuidado de sí.</span> Nos comprometemos a ofrecer contenido de
                    calidad que inspire la reflexión y el desarrollo espiritual,
                    emocional e intelectual, promoviendo una vida equilibrada y
                    significativa.
                </p>
                <h3 class="mb-3 fade-in-right subtitle-size">Visión</h3>
                <p class="fade-in-up m-0">
                    <span class="fw-bold">Ser líderes en autocuidado integral</span>, empoderando a las
                    personas para transformar sus vidas mediante el
                    autoconocimiento, la autodisciplina y el desarrollo personal,
                    promoviendo una comunidad comprometida con el bienestar
                    propio y el de su entorno.
                </p>
            </article>
        </div>
    </div>
</div>
<div class="section-bio" id="biografia">
    <div class="container">
        <div class="row align-items-start">
            <div class="col-12 col-md-6 d-flex justify-content-center align-items-start mb-4 mb-md-0">
                <img src="../public/assets/images/home/BIOGRAFIA.png" alt="Foto de Ramiro Álvarez" class="img-fluid rounded-4" style="object-fit:cover;" loading="eager">
            </div>
            <div class="col-12 col-md-6">
                <h2 class="h2-title fade-in-left">BIOGRAFÍA</h2>
                <span class="fade-in-left title">
                    <span class="circle-responsive" style="color: #19b0df; font-size: 3rem;">●</span>
                    <span class="fs-1 subtitle">Fr. Ramiro Álvarez</span>
                </span>
                <div class="b-rounded fade-in-up">
                    <p class="px-4 py-1 fade-in-up">Filósofo, teólogo y psicólogo</p>
                </div>
                <p class="fw-bold fade-in-up">
                    Ramiro A. Álvarez nació en Colombia. Es licenciado en Filosofía,
                    Teología y Psicología, y posee una maestría en Recursos Humanos y
                    Comportamiento Organizacional de la Pontificia Universidad Católica
                    de Chile.
                </p>
                <p class="fade-in-up">
                    Con más de 29 años de experiencia, ha impartido conferencias, talleres y
                    cursos a nivel internacional, labor que complementa con su vocación como
                    sacerdote y terapeuta.
                </p>
                <p class="fade-in-up">
                    A lo largo de su carrera, ha desarrollado investigaciones en psicoanálisis,
                    Sagrada Escritura, problemas de aprendizaje y liderazgo organizacional. Su
                    sólida formación académica y vasta trayectoria lo han consolidado como un
                    referente en la intersección entre ciencia y espiritualidad, abordando
                    ambos campos desde una perspectiva transdisciplinaria.
                </p>
                <p class="fade-in-up">
                    Su proyecto más reciente, Cuidado de Sí (cuidadodesi.com), busca
                    promover un enfoque integral que inspire el crecimiento personal a través
                    de la espiritualidad, el autoconocimiento y el desarrollo de la inteligencia
                    emocional.
                </p>
            </div>
        </div>
    </div>
</div>
<section class="section-services d-flex justify-content-center align-items-center">
    <div class="container section-home-margin">
        <div class="text-center border-bottom pb-4">
            <h2 class="fs-5 fade-in-up subtitle-size">SERVICIOS</h2>
        </div>
        <div class="row g-4 mt-5">
            <!-- Conferencias -->
            <div class="col-12 col-md-4">
                <article class="article-service h-100 d-flex flex-column">
                    <div>
                        <img src="../public/assets/images/CONFERENCIAS.png" alt="Conferencias"
                            class="img-fluid rounded-4" style="object-fit:cover; height:250px;" loading="eager">
                        <h3 class="fade-in-left subtitle-size mb-0 mt-5">Conferencias</h3>
                        <div class="container-p mt-5">
                            <p class="fade-in-left"><span class="fw-bold">Mente, cuerpo y espíritu</span>: el camino hacia la armonía interior.</p>
                            <p class="fade-in-left">Adolescencia, ¿oportunidad o desafío?</p>
                            <p class="fade-in-left"><span class="fw-bold">Re-pensar el duelo</span>: Del dolor al aprendizaje.</p>
                        </div>
                    </div>
                    <a href="?page=services" class="btn btn-light rounded-4 mt-5">Ver más</a>
                </article>
            </div>

            <!-- Cursos y talleres -->
            <div class="col-12 col-md-4">
                <article class="article-service h-100 d-flex flex-column">
                    <div>
                        <img src="../public/assets/images/CURSOS Y TALLERES.png" alt="Cursos y talleres"
                            class="img-fluid rounded-4" style="object-fit:cover; height:250px;" loading="eager">
                        <h3 class="fade-in-up subtitle-size mb-0 mt-5">Cursos y talleres</h3>
                        <div class="container-p mt-5">
                            <a href="?page=curso" class="fw-bold fade-in-up" style="color: white;">Geometría del Alma</a>
                        </div>
                    </div>
                    <a href="?page=services" class="btn btn-light rounded-4 mt-5">Ver más</a>
                </article>
            </div>

            <!-- Terapia -->
            <div class="col-12 col-md-4">
                <article class="article-service h-100 d-flex flex-column">
                    <div>
                        <img src="../public/assets/images/TERAPIA.png" alt="Terapia"
                            class="img-fluid rounded-4" style="object-fit:cover; height:250px;" loading="eager">
                        <h3 class="fade-in-right subtitle-size mb-0 mt-5">Terapia</h3>
                        <div class="container-p mt-5">
                            <p class="fw-bold fade-in-right">En línea</p>
                            <p class="fw-bold fade-in-right">En persona</p>
                        </div>
                    </div>
                    <a href="?page=services" class="btn btn-light rounded-4 mt-5">Ver más</a>
                </article>
            </div>
        </div>
    </div>
</section>


<div class="container section-home-margin" id="galeria">
    <h2 class="h2-title fade-in-left">GALERÍA</h2>
    <div class="d-flex justify-content-between align-items-center mb-2">
        <h2 class="fade-in-left">
            <span class="align-middle circle-responsive" style="color: #19b0df; font-size: 3rem;">●</span>
            <span class="align-middle subtitle">Eventos Recientes</span>
        </h2>
        <div class="d-flex justify-content-around align-items-center">
            <button type="button" class="btn-arrow me-3" id="prev">
                <i class="fa-solid fa-arrow-left fa-lg"></i>
            </button>
            <button type="button" class="btn-arrow" id="next">
                <i class="fa-solid fa-arrow-right fa-lg"></i>
            </button>
        </div>
    </div>
    <div class="row row-cols-1 row-cols-md-3 g-3" id="recent_events">
    </div>
</div>
<div class="container section-home-margin" id="eventos">
    <h2 class="h2-title fade-in-left">EVENTOS</h2>
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="m-0 fade-in-left">
            <span class="align-middle circle-responsive" style="color: #19b0df; font-size: 3rem;">●</span>
            <span class="align-middle subtitle">Próximos Eventos</span>
        </h2>
        <div class="d-flex justify-content-around align-items-center">
            <button type="button" class="btn-arrow me-3" id="prev_events">
                <i class="fa-solid fa-arrow-left fa-lg"></i>
            </button>
            <button type="button" class="btn-arrow" id="next_events">
                <i class="fa-solid fa-arrow-right fa-lg"></i>
            </button>
        </div>
    </div>
    <div class="container-events d-flex flex-column justify-content-end align-items-end p-4 position-relative">
        <div class="bg-image"></div>
        <div class="overlay"></div>
        <div class="contenido position-relative" style="width: 35%;">
            <div class="text-white d-flex flex-column mb-4">
                <div class="mb-4">
                    <span class="fw-bold fs-3" id="event_name">Evento</span>
                </div>
                <div class="mb-2">
                    <i class="fa-solid fa-calendar-days"></i>
                    <span class="ms-2" id="event_date">25 Mayo</span>
                </div>
                <div>
                    <i class="fa-solid fa-location-dot"></i>
                    <span class="ms-2" id="event_place">Monterrey</span>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="container section-home-margin videos_responsive" id="videos">
    <h2 class="h2-title fade-in-left">VIDEOS</h2>
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="fade-in-left">
            <span class="align-middle circle-responsive" style="color: #19b0df; font-size: 3rem;">●</span>
            <span class="align-middle subtitle">Encuéntranos en Youtube</span>
        </h2>
        <div class="d-flex justify-content-around align-items-center">
            <button type="button" class="btn-arrow me-3" id="prev_videos">
                <i class="fa-solid fa-arrow-left fa-lg"></i>
            </button>
            <button type="button" class="btn-arrow" id="next_videos">
                <i class="fa-solid fa-arrow-right fa-lg"></i>
            </button>
        </div>
    </div>
    <div class="row row-cols-1 row-cols-md-2 g-4 videos" id="videosVal">
    </div>
</div>
<div class="section-home-two d-flex justify-content-start align-items-center">
    <div class="container py-5">
        <div class="d-flex flex-column justify-content-center align-items-center">
            <div>
                <span class="fade-in-left title one" style="font-size: 4rem;">Transforma tu vida</span>
            </div>
            <div class="mt-3">
                <span class="fade-in-left title two" style="font-size: 6rem;">desde el interior</span>
            </div>
        </div>
    </div>
</div>
<div class="container section-home-margin section-blog">
    <div class="row">
        <div class="col-12 col-md-6 d-flex justify-content-center align-items-start mb-4 mb-md-0">
            <img src="../public/assets/images/home/BLOG.png" alt="blog" class="img-fluid rounded-4" style="object-fit:cover;" loading="lazy">
        </div>
        <div class="col-12 col-md-6">
            <h2 class="h2-title fade-in-left">BLOG</h2>
            <span class="fade-in-left title">
                <span class="circle-responsive" style="color: #19b0df; font-size: 3rem;">●</span>
                <span class="fs-1 subtitle">Guía para tu bienestar</span>
            </span>
            <p class="fw-bold fade-in-up" style="text-align: justify;">
                Un ser humano que cuida de sí mismo es alguien que ama y respeta su
                entorno. Al integrar estos conceptos en nuestra vida diaria, podemos
                avanzar hacia un estilo de vida más equilibrado y armonioso.
            </p>
            <p class="fade-in-up" style="text-align: justify;">
                El cuidado, la sostenibilidad, la razón sensible, la ecología -tanto interior
                como exterior-y la biofilia nos ofrecen un marco holístico para afrontar los
                desafíos del presente y construir un futuro más saludable y justo.
            </p>
            <p class="fade-in-up" style="text-align: justify;">
                Adoptar estos principios no solo favorece nuestro bienestar personal, sino
                que también contribuye al bienestar de nuestra comunidad y del planeta.
                De este modo, juntos podemos crear un mundo en el que vivir en armonía
                con nosotros mismos, con los demás y con la naturaleza sea una realidad
                tangible.
            </p>
        </div>
    </div>
</div>
<div class="container section-home-margin section-blog-list">
    <h2 class="mb-4 fade-in-left subtitle">Blog</h2>
    <div class="row g-4 mb-5" id="alert">
        <div class="col-12 col-md-6">
            <div class="h-100" id="recent_blog">
            </div>
        </div>
        <div class="col-12 col-md-6">
            <div class="row g-4" id="blogs">
            </div>
        </div>
    </div>
    <div class="d-flex justify-content-center mt-5">
        <?php
        // Detectar el idioma actual de manera más robusta
        $current_path = $_SERVER['REQUEST_URI'] ?? '';
        $is_english = strpos($current_path, '/en/') !== false;
        ?>
        <a href="?page=blog" class="btn rounded-4 text-white fw-semibold btn-lg px-5" style="background-color: #19b0df;">
            Más Blogs
        </a>
    </div>
</div>
<div class="gallery-images" id="gallery-images">
    <div class="container-fluid d-flex flex-column justify-content-center align-items-center py-5" style="height: 100%;">
        <div id="galleryCarousel" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-inner" id="gallery_carousel_inner">
            </div>
            <button id="carousel-prev" class="carousel-control-prev" type="button" data-bs-target="#galleryCarousel" data-bs-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Anterior</span>
            </button>
            <button id="carousel-next" class="carousel-control-next" type="button" data-bs-target="#galleryCarousel" data-bs-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Siguiente</span>
            </button>
        </div>
        <div class="text-center text-white mt-4 px-4" id="gallery_detail">
        </div>
    </div>
</div>