<?php
require_once __DIR__ . '/../models/Video.php';
header('Content-Type: application/json');   
class VideoController
{
    public static function index($status){
        $videos = Video::all($status);
        echo json_encode([
            'success' => true,
            'message' => 'Videos retrieved successfully!',
            'videos' => $videos
        ]);
    }
    public static function store($link){
        if(Video::create($link)){
            echo json_encode([
                'success' => true,
                'message' => 'Video created successfully!',
            ]);
        }else{
            echo json_encode([
                'success' => false,
                'message' => 'Error creating video'
            ]);
        }
    }

    public static function show($id){
        $video = Video::findById($id);
        echo json_encode([
            'success' => true,
            'message' => 'Video found successfully!',
            'video' => $video
        ]);
    }

    public static function update(int $id, $link, $status)
    {
        if(Video::update($id,['link'=>$link, 'status'=>$status])){
            echo json_encode([
                'success' => true,
                'message' => 'Video updated successfully!',
            ]);
        }else{
            echo json_encode([
                'success' => false,
                'message' => 'Error updating video'
            ]);
        }
    }

    public static function status(int $id, $status)
    {
        if(Video::update($id,['status'=>$status])){
            echo json_encode([
                'success' => true,
                'message' => 'Video updated successfully!',
            ]);
        }else{
            echo json_encode([
                'success' => false,
                'message' => 'Error updating video'
            ]);
        }
    }
}