$(function () {
    $.ajax({
        url: './routes/web.php',
        type: 'GET',
        data: { REQUEST_URI: '/events/find-by-id', id: $('#id').val() },
        success: (response) => {
            if (response.success) {
                $('#id').val(response.event.id)
                $('#name').val(response.event.name)
                $('#place').val(response.event.place)
                $('#date').val(response.event.date)
                $('#status').val(response.event.status)
            }
            if (response.event.banner) {
                const bannerUrl = `./resources/images/events/${response.event.banner}`;
                pond.files = [
                    {
                        source: response.event.banner,
                        options: {
                            type: 'local',
                            metadata: {
                                poster: bannerUrl
                            }
                        }
                    }
                ];
            }
        },
        error: (error) => {
            console.log('Error: ', error)
            Swal.fire({
                icon: 'error',
                title: '¡Error!',
                text: 'Hubo un error al obtener los datos del evento'
            }).then(() => {
                window.location.href = '?page=events'
            });
        }
    })

    FilePond.registerPlugin(FilePondPluginImagePreview,
        FilePondPluginFileValidateType,
        FilePondPluginImageResize,
        FilePondPluginImageCrop,
        FilePondPluginFileValidateSize,
        FilePondPluginFilePoster
    );

    const pond = FilePond.create(document.getElementById('banner'), {
        instantUpload: false,
        allowProcess: false,
        allowRevert: false,
        labelIdle: 'Arrastra tu imagen aquí o <span class="filepond--label-action">Selecciona</span>',
        labelInvalidField: 'Campo inválido',
        labelFileLoading: 'Cargando',
        labelFileLoadError: 'Error al cargar',
        labelFileProcessing: 'Procesando',
        labelFileProcessingComplete: 'Procesado',
        labelFileProcessingAborted: 'Procesamiento cancelado',
        labelFileProcessingError: 'Error al procesar',
        labelFileProcessingRevertError: 'Error al revertir',
        labelFileRemoveError: 'Error al eliminar',
        labelTapToCancel: 'Toca para cancelar',
        labelTapToRetry: 'Toca para reintentar',
        labelTapToUndo: 'Toca para deshacer',
        labelButtonRemoveItem: 'Eliminar',
        labelButtonAbortItemLoad: 'Abortar',
        labelButtonAbortItemProcessing: 'Cancelar',
        labelButtonUndoItemProcessing: 'Deshacer',
        labelButtonRetryItemProcessing: 'Reintentar',
        labelButtonProcessItem: 'Subir',
        labelMaxFileSizeExceeded: 'El archivo es demasiado grande',
        labelMaxFileSize: 'El tamaño máximo del archivo es {filesize}',
        maxFiles: 1,
        acceptedFileTypes: ['image/*'],
        maxFileSize: '1MB',
        imagePreviewHeight: 200,
        imageCropAspectRatio: '16:9',
        imageResizeTargetWidth: 800,
        imageResizeTargetHeight: 450,
        styleItemPanelAspectRatio: 0.5,
        styleLoadIndicatorPosition: 'center bottom',
        styleProgressIndicatorPosition: 'right bottom',
        styleButtonRemoveItemPosition: 'left bottom',
        styleButtonProcessItemPosition: 'right bottom',
        server: {
            url: './routes/upload.php',
            method: 'POST',
            withCredentials: false,
            headers: {},
            timeout: 7000,
        }
    });

    const showError = (input, message) => {
        $(input).after(`<span class="text-danger">${message}</span>`)
    }

    const clearError = (input) => {
        $(input).next('.text-danger').remove()
    }

    $('#form').on('submit', (e) => {
        e.preventDefault()
        let hasErrors = false

        const name = $('#name').val()
        const place = $('#place').val()
        const date = $('#date').val()
        const status = $('#status').val()

        clearError('#name')
        clearError('#place')
        clearError('#date')
        clearError('#banner')
        clearError('#status')

        if (!name) {
            showError('#name', 'El nombre es requerido')
            hasErrors = true
        } else if (name.lenght > 255) {
            showError('#name', 'El nombre no puede ser mayor a 255 caracteres')
            hasErrors = true
        }

        if (!place) {
            showError('#place', 'El lugar es requerido')
            hasErrors = true
        } else if (place.length > 255) {
            showError('#place', 'El lugar no puede ser mayor a 255 caracteres')
            hasErrors = true
        }

        if (!date) {
            showError('#date', 'La fecha es requerida')
            hasErrors = true
        }

        if (pond.getFiles().length === 0) {
            showError('#banner', 'La imagen es requerida');
            hasErrors = true;
        }

        if (!status) {
            showError('#status', 'El estado es requerido')
            hasErrors = true
        }

        if (hasErrors) return
        pond.processFiles().then(file => {
            const filePond = pond.getFile()
            const formData = {
                id: $('#id').val(),
                name: name,
                place: place,
                date: date,
                banner: filePond.serverId,
                status: status
            }

            $.ajax({
                url: './routes/web.php',
                type: 'POST',
                data: { REQUEST_URI: '/events/update', data: formData, },
                success: (response) => {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: '¡Exito!',
                            text: response.message,
                            showConfirmButton: false,
                            timer: 1500
                        }).then(() => {
                            window.location.href = '?page=events'
                        });
                    }
                },
                error: (error) => {
                    console.log('Error: ', error)
                    Swal.fire({
                        icon: 'error',
                        title: '¡Error!',
                        text: 'Hubo un error al procesar la solicitud'
                    });
                }
            })
        })
    })
})