$(() => {
    $.ajax({
        url: './routes/web.php',
        type: 'GET',
        data: { REQUEST_URI: '/videos/find-by-id', id: $('#id').val() },
        success: (response) => {
            if (response.success) {
                $('#id').val(response.video.id)
                $('#link').val(response.video.link)
                $('#status').val(response.video.status)
            }
        },
        error: (error) => {
            console.log('Error: ', error)
            Swal.fire({
                icon: 'error',
                title: '¡Error!',
                text: '¡Hubo un error al obtener los datos del video!'
            }).then(() => {
                window.location.href = '?page=videos'
            });
        }
    })

    const showError = (input, message) => {
        $(input).after(`<span class="text-danger ms-2">${message}</span>`)
    }

    const clearError = (input) => {
        $(input).next('.text-danger').remove()
    }

    $('#form').on('submit', async (e) => {
        e.preventDefault();
        let hasErrors = false

        const formData = {
            id: $('#id').val(),
            link: $('#link').val(),
            status: $('#status').val()
        }

        clearError('#link')
        clearError('#status')

        if (!formData.link) {
            showError('#link', 'El link es requerido')
            hasErrors = true
        } else if (formData.link.length > 255) {
            showError('#link', 'El link no puede tener más de 255 caracteres')
            hasErrors = true
        }

        if (!formData.status) {
            showError('#status', 'El estado es requerido')
            hasErrors = true
        }

        if (hasErrors) return

        $.ajax({
            url: './routes/web.php',
            type: 'POST',
            data: { REQUEST_URI: '/videos/update', data: formData },
            success: (response) => {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: '¡Exito!',
                        text: response.message,
                        showConfirmButton: false,
                        timer: 1500
                    }).then(() => {
                        window.location.href = '?page=videos'
                    });
                }
            },
            error: (error) => {
                console.log('Error: ', error)
                Swal.fire({
                    icon: 'error',
                    title: '¡Error!',
                    text: '¡Hubo un error al procesar la solicitud!'
                });
            }
        })
    })
})