$(document).ready(function () {

    $('.contactForm').submit(function (e) {
        var overlay = $('#contacto-overlay');
        if (overlay.css('display') === 'none' || !overlay.hasClass('active')) {
            e.preventDefault();
            return;
        }

        e.preventDefault();
        var form = $(this);
        $.ajax({
            type: 'POST',
            url: 'php/enviarmail.php',
            data: form.serialize(),
            success: function (response) {
                var data = JSON.parse(response);
                if (data.success) {
                    showalert('success', data.message);
                    form[0].reset();
                } else {
                    showalert('danger', data.message);
                    form[0].reset();
                }
            },
            error: function (response) {
                console.log(response.responseText);
            }
        });

        function showalert(type, message) {
            var notyf = new Notyf({
                duration: 3000,
                position: { x: 'center', y: 'top' }
            });

            if (type === 'success') {
                notyf.success(message);
            } else if (type === 'danger') {
                notyf.error(message);
            }
        }
    });
});

